import requests
import sys
import json
import time

def parse_params(args, param_name):
    for arg in args:
        if arg.startswith(f"{param_name}="):
            return arg.split("=")[1]
    return None

def main():
    ch = parse_params(sys.argv, 'ch')
    pssh = parse_params(sys.argv, 'pssh')
    
    if not ch or not pssh:
        print("Error: Missing required parameters 'ch' or 'pssh'.")
        return

    # Corrige PSSH
    padding_needed = (4 - len(pssh) % 4) % 4
    pssh += '=' * padding_needed
    

    try:
        response = requests.get(f'http://134.65.227.106/clarotv/key.php?pssh={pssh}&ch={ch}')           
        print(response.text)
        time.sleep(5)
    except requests.exceptions.RequestException as e:
        print(f"Error while making request: {e}")
    except json.JSONDecodeError:
        print("Error: Response is not valid JSON.")

if __name__ == "__main__":
    main()
